#!/usr/bin/perl
use DBI;
use XBase;
use GD::Graph::lines;
use Time::localtime;
use Time::Local;

my $tm = localtime;
my $TIME = timelocal($tm->sec, $tm->min, $tm->hour, $tm->mday,$tm->mon, $tm->year+1900);
$TIME = $TIME - 3 * 60 * 60;
my $tm = localtime($TIME);
my $czas =  sprintf("%04d", $tm->year+1900) . sprintf("%02d", $tm->mon+1) . sprintf("%02d", $tm->mday) .
	    sprintf("%02d", $tm->hour) .  sprintf("%02d", $tm->min) . sprintf("%02d", $tm->sec);

my $dbh = DBI->connect("DBI:XBase:/root/sbin") or die $dbh->errstr();
my $sth = $dbh->prepare("select TEMPER, CPU, CZAS from temperatura where CZAS>=?") or die $dbh->errstr();
$sth->execute($czas);

while (@d = $sth->fetchrow_array) {
    push @val1, $d[0];
    push @val2, $d[1];
    push @row,  substr($d[2],8,2) . ":" . substr($d[2],10,2);
    }
$dbh->disconnect;

my @data = ([@row],[@val1],[@val2]); 
my $my_graph = GD::Graph::lines->new(490,250); 
$my_graph->set(
    two_axes => 1,
    zero_axis => 1,
    x_label_skip => 23,
    title => 'Temperatura i uycie procesora',
    transparent => 0,
    );

$my_graph->set_legend( 'lewa strona - temperatura', 'praw strona - cpu' );
my $gd = $my_graph->plot(\@data) or die $my_graph->error;
open(IMG, '>/var/www/htdocs/temperatura.gif') or die $!;
binmode IMG;
print IMG $gd->gif;
close IMG;
                                                                        